{ Legende
  21.02.2007  V1.0.0.0  Aufbau von einer QPortUSB-Komponente wurde festgelegt.
                        Nach Experimentalboard QUSB-TTL24 fr die Einbindung
                        im Digital - Analyser. DLL von QUANTUM.com
                        Umgesetzt auf Komponentenbetrieb und ein Paar andere
                        Sachen noch verndert.
                        Benutzt wird eigentliche der DLL-Treiber.
                        Dieser funktioniert in Windows 98, 2000, NT, XP
  21.02.2007  V1.0.0.4  QPortUSB-Komponente wurde als Betaphase zu Verfgung
                        gestellt.
  22.02.2007  V1.0.0.7  Fehler beseitigt und das festlegen der Portrichtung
                        sind jetzt eingebunden.
  03.03.2007  V1.0.0.8  Fehlermeldung in Deutsch und Englisch, sind jetzt
                        vorhanden.  Die Fehlermeldung von der DLL werden z.Zt.
                        nicht ausgewertet.

}

unit QPortUSB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DsgnIntf, QPortUSBAbout;

const
     FVersion = '1.0.0.8';           // Aktuelle Version

{$INCLUDE qlib.pas}

{ ---------------------------------------------------------------------
  Record wird fr die Selektion der Byte-Daten bentigt.
  --------------------------------------------------------------------- }
type Tlongint = record
           low1,
           hig1,
           low0,
           hig0 : byte;
           end;

{ ---------------------------------------------------------------------
  Record wird fr die Selektion der Byte-Daten bentigt.
  --------------------------------------------------------------------- }
type Twordint = record
           loword,
           hiword : word;
           end;

type TQUSBConnect = ( auto, user );
type TQUSBcommand = ( input, output );
type TQUSBLanguage = ( English, German );

type TQUSBstruct = record
     active   : boolean;
     number   : integer;
     portcmd  : TQUSBcommand;
     lpcd     : CARDDATAS;
     device   : longint;
     handle   : longint;
     result   : longint;
     end;

type
{ ---------------------------------------------------------------------
  Fehlerklasse fr TPort_USB erzeugen
  --------------------------------------------------------------------- }
EPortUSBComponentExists = class(Exception);

type
  TQPortUSB = class(TComponent)
  private
    { Private-Deklarationen }
    FQAbout                  : TQPortUSBAbout;
    FQUSBLanguage            : TQUSBLanguage;
    fcmpname                 : string;       // Interner Komponentenname
    FErrtxt                  : string;       // Fehlermeldungsart
    Fmsgtxt                  : string;       // Fehlermeldung
    FErrNumber               : integer;      // Fehlernummer
    FQUSBportactive          : boolean;
    FQUSBarray               : array[0..7] of TQUSBstruct;
    FQUSBportConnect         : TQUSBConnect;
    FQUSBportAddr            : integer;
    FQUSBportTest            : boolean;
    FQUSBprocess             : boolean;
    FQUSBStopProcess         : boolean;


  protected
    { Protected-Deklarationen }
    // USB Karten - Adresse setzen
    procedure SetQUSBportAddr( avalue : integer );

    //######################################################
    //## Fr die Eigenschaft-Property Port, WPort und DPort
    //######################################################

    // Digit USB - Port Kommado
    function     GetQUSBcommand :TQUSBcommand;
    procedure    SetQUSBcommand( avalue: TQUSBcommand );

    // Digi USB - Port einlesen
    function    GetQPort :byte;
    function    GetQWPort:word;
    function    GetQDPort:dword;
    // Digi USB - Port schreiben
    procedure SetQPort (Data:byte);
    procedure SetQWPort(Data:word);
    procedure SetQDPort(Data:dword);

    // Interne Eigenschaft
    property ErrorNumber  : integer
             read FErrNumber write FErrNumber;

  public
    { Public-Deklarationen }
    // 1. Die Methode erzeugt und initialisiert ein TLptIO-Objekt.
    constructor Create(AOwner: TComponent); override;
    // Die Methode Destroy entledigt sich der Komponente und der Komponenten,
    // die zu dieser gehren.
    destructor Destroy; override;
    // 2. Die Methode SetName legt den Wert der Eigenschaft Name fest.
    procedure SetName(const NewName: TComponentName); override;
    // 3. Loaded ermglicht einer Komponente, sich selbst zu initialisieren,
    // nachdem alle ihre Teile aus einem Stream geladen wurden.
    procedure Loaded; override;
    // 4. Die Methode Notification leitet Benachrichtigungen an alle untergeordneten Komponenten weiter.
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;

    // USB Karte aktivieren
    procedure SetQUSBportactive( avalue : boolean );
    function  GetQUSBportactive: boolean;

    // USB Port Karte prfen
    procedure SetQUSBportTest( avalue : boolean );
    procedure StopQUSBprocess;

    // Byte - Port X
    property BPort: byte
             read GetQPort write SetQPort;
    // Word - Port X
    property WPort : word
             read GetQWPort write SetQWPort;
    // Dword - Port X
    property DPort : dword
             read GetQDPort write SetQDPort;

    // Hilfsfunktion - Fehlermeldung
    function QUSBCheckactive   : boolean;
    function QUSBCheckerror    : boolean;
    function QUSBReaderrnumber : integer;
    function QUSBReaderrorstr  ( avalue : integer; svalue : string ): string;
    // Fehlermeldung per Dialogbox ausgeben
    procedure SetQerrmessage   ( Value : integer; Svalue : string );




  published
    { Published-Deklarationen }

    // Info ber die Komponente
    property About : TQPortUSBAbout
             read FQAbout write FQAbout;

    // Landesparache
    property USBLanguage : TQUSBLanguage
             read FQUSBLanguage write FQUSBLanguage;

    // Port ffnen oder schlieen
    property USBportactive : boolean
             read GetQUSBportactive write SetQUSBportactive;

    //
    property USBportconnect : TQUSBConnect
             read FQUSBportConnect write FQUSBportConnect;

    // Portadresse festlegen
    property USBportAddr : integer
             read FQUSBportAddr write SetQUSBportAddr;

    // Port Ausrichtung festlegen
    property USBPortCMD: TQUSBcommand
             read GetQUSBcommand write SetQUSBcommand;

    // Test der USB Karte durchfhren
    property USBportTest : boolean
             read FQUSBportTest write SetQUSBportTest;

    // USB Process, wenn TURE ist muss man warten
    property USBprocess : boolean
             read fQusbprocess;

  end;

procedure Register;

implementation



procedure Register;
begin
  RegisterComponents('Mak', [TQPortUSB]);
  RegisterPropertyEditor(TypeInfo(TQPortUSBAbout), TQPortUSB, 'ABOUT', TQPortUSBAbout);
end;

//***************************************************************************
//
// TQPortUSB - Komponente aktivieren
//
// Eingabewerte  :
// AOwner:                   TComponent
//
// Rckgabewerte :
//
//***************************************************************************
constructor TQPortUSB.Create(AOwner: TComponent);
var
   xself : boolean;
   tcs : TComponentState;

begin
  inherited Create(AOwner);    // Alle Funktionen von TComponent aktivieren

  tcs := ComponentState;
  xself := true;
  if csLoading in tcs then xself := false;
  if csReading in tcs then xself := false;
  if csDestroying in tcs then xself := false;
  if csDesigning in tcs then xself := false;
  if csAncestor in tcs then xself := false;
  if csUpdating in tcs then xself := false;
  if csFixups in tcs then xself := false;
  if csFreeNotification in tcs then xself := false;
  if csInline in tcs then xself := false;

  // Entwickeln von Komponenten und auf sich selbst zeigen ( SELF ).
  if xself then
     fcmpname := 'SELF TQPortUSB'
  else
      fcmpname := Name;

  FQUSBportTest         := false;
  FQUSBportAddr         := 1;
  FQUSBprocess          := false;
  FQUSBStopProcess      := false;
end;


//***************************************************************************
//
// TPort_USB - Komponente deaktivieren
// Eingabewerte  :
//
// Rckgabewerte :
//
//***************************************************************************
destructor TQPortUSB.Destroy;
var
   cardaddr : integer;
begin
   while ( FQUSBprocess ) do
      begin
         // Warten
         Application.ProcessMessages;
      end;
   // Jetzt kanns los gehen.

   // release all QLIB Handles here
   for cardaddr := 0 to 7 do
   begin
        if ( FQUSBarray[cardaddr].handle <> 0) then
        begin
             QAPIExtCloseCard(FQUSBarray[cardaddr].handle);
             FQUSBarray[cardaddr].handle := 0;
        end;
   end;

   inherited Destroy;   // Alle Komponenten Funktionen lschen
end;

//***************************************************************************
//
// Zweiter Schritt bei der Erzeugung von Komponenten
//
// Wird bentig, damit man auf die korrekte Komponente aufsetzt, da sonst
// eine Komponente gelscht wird die aber noch in der Komponentenliste ist.
// Es kommt dann unweigerlich zu einer Speicherverletzung.
//
//
// Die Methode SetName setzt die Eigenschaft Name virtuell.
// Sie ruft die Methode ChangeName auf, welche die eigentliche
// nderung des Namens durchfhrt.
// ChangeName ist nicht virtuell. berschreiben Sie statt dessen SetName,
// wenn Sie das Verhalten der Eigenschaft Name ndern wollen.
//
//***************************************************************************
procedure TQPortUSB.SetName(const NewName: TComponentName);
begin
     inherited Setname( NewName );
     FErrtxt := NewName + ' Component - Error';
end;

//***************************************************************************
//
// Letzter Schritt bei der Erzeugung von Komponenten
//
// TAsciidelmit - Loaded ermglicht einer Komponente, sich selbst zu
// initialisieren, nachdem alle ihre Teile aus einem Stream geladen wurden.
//
// Wenn eine Delphi- Anwendung beispielsweise ein Formular aus der
// entsprechenden Formulardatei ldt, erzeugt sie zuerst die Formularkomponente,
// indem sie ihren Konstruktor aufruft. Anschlieend liest sie die Eigenschafts-
// werte aus der Formulardatei. Nachdem alle Eigenschaftswerte aller Komponenten
// gelesen wurden, ruft Delphi die Methode Loaded fr jede Komponente in der
// Reihenfolge auf, in der die Komponenten erzeugt wurden. Dadurch haben die
// Komponenten die Mglichkeit, alle Daten zu initialisieren, die von Werten
// anderer Komponenten abhngig sind.
//
// Hinweis
// Alle Referenzen auf gleichrangige Komponenten werden vor dem Aufruf von
// Loaded aufgelst. Zeiger auf gleichrangige Komponenten, die aus einem Stream
// gelesen wurden, knnen frhestens in diesem Aufruf von Loaded verwendet
// werden.
//
// Achtung
// Die Methode Loaded kann fr geerbte Formulare mehrere Male aufgerufen werden.
// Sie wird jedes Mal aufgerufen, wenn eine Vererbungsebene eingelesen wird.
// Weisen Sie in einer berschriebene Loaded-Methode keinen Speicher zu,
// ohne zuerst zu berprfen, ob der Speicher nicht bereits bei einem frheren
// Aufruf zugewiesen wurde.
//
//***************************************************************************
procedure TQPortUSB.Loaded;
begin
     inherited Loaded;
     USBportactive := false;
     USBportConnect := auto;
end;


//***************************************************************************
//
// Rufen Sie die Methode Notification nicht in einer Anwendung auf.
// Notification wird automatisch aufgerufen, wenn die im Parameter AComponent
// bergebene Komponente in Abhngigkeit vom Wert des Parameters Operation
// entweder eingefgt oder entfernt wird. Standardmig leiten Komponenten
// Benachrichtigungen an die ihnen untergeordneten Komponenten weiter.
//
// Eine Komponente kann, falls erforderlich, auf die Benachrichtigung reagieren,
// da eine Komponente entweder eingefgt oder entfernt wird.
// Wenn beispielsweise eine Komponente Objektfelder oder Eigenschaften enthlt,
// die auf andere Komponenten verweisen, kann sie anhand der Benachrichtigungen
// prfen, ob solche Komponenten entfernt wurden, und die entsprechenden
// Referenzen fr ungltig erklren.
//
//***************************************************************************

procedure TQPortUSB.Notification(AComponent: TComponent; Operation: TOperation);
begin

     case Operation of
          // Das angegebene Objekt wurde gelscht und der zugewiesene Speicher
          // wird gerade freigegeben.
          opRemove : begin

                      // Jemadn macht zur Zeit etwas, wir mssen warten
                      while ( FQUSBprocess ) do
                            begin
                               sleep( 1 );
                               //Application.ProcessMessages;
                            end;
                     end;
     end;

     inherited Notification( AComponent, Operation );

end;


//***************************************************************************
//
// TPort_USB.SetUSBportactive - QUSB-TTL24 Karte aktivieren
//
// Eingabewerte  :   TRUE = aktiv, FALSE = schlieen
//
// Rckgabewerte :
//
//***************************************************************************
procedure TQPortUSB.SetQUSBportactive( avalue : boolean );
var
   found_usbnr, CardAddr, DDR :longint;
begin

     // AUSGABE
     // USB - TTL 24 - OUT (alle Ports Hex $07)
     //
     // DDR := DDR or $01;  // Port 0 - 7
     // DDR := DDR or $02;  // Port 8 - 15
     // DDR := DDR or $04;  // Port 16 - 23
     DDR := 7;

     case USBportconnect of
          // Der Anwender whlt die USB - Karte aus.
          user :
          begin
               CardAddr := USBportaddr;

               //Prfen, ob Adresse korrekt angegeben wurde.
               if (CardAddr >= 1) and (CardAddr <= 8) and not (FQUSBprocess) and not (FQUSBStopProcess) then
               begin
                    FQUSBprocess := true;        // Process luft jetzt

                    dec( CardAddr );  // Zhlweise 0 - 7 nur fr Anwender 1 - 8

                    // Gravierende Probleme beim ermitteln der USB-Karte
                    found_usbnr := -2;

                    // Prfen, ob schon offen
                    if (FQUSBarray[cardaddr].active = false) and (avalue = true) then
                    begin
                         //Nein, USB Karte ffnen wenn NULL
                         if FQUSBarray[cardaddr].handle = 0 then
                         begin
                              FQUSBarray[cardaddr].handle := QAPIExtOpenCard(USBTTL24, cardaddr);
                              // Prfe, ob Karte gefunden wurde!
                              if FQUSBarray[cardaddr].handle <> 0 then
                              begin
                                   // Geschaft, USB - Karte da!!
                                   found_usbnr := cardaddr;
                              end;
                         end
                         else
                             found_usbnr := -1;


                         // Hat alles geklappt ???
                         case found_usbnr of
                              0..7 :
                              begin
                                   // Prima Karte geffnet
                                   FQUSBportactive := true;
                                   FQUSBarray[cardaddr].active := FQUSBportactive;
                                   FQUSBarray[cardaddr].number := cardaddr;
                                   FQUSBportaddr := cardaddr +1;  // Fr Anwender 1-8

                                   // Portrichtung festlegen
                                   case USBPortCMD of
                                        input:
                                        begin
                                             FQUSBarray[cardaddr].portcmd := USBPortCMD;
                                             DDR := DDR AND $F8;
                                             // set the ddr register ( DDR = data direction register )
                                             QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                                        end;
                                        output:
                                        begin
                                             FQUSBarray[cardaddr].portcmd := USBPortCMD;
                                             // set the ddr register ( DDR = data direction register )
                                             QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                                        end;
                                   end;

                                   // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                   if FQUSBStopprocess then
                                   begin
                                        FQUSBStopprocess := false;
                                        FQUSBprocess     := false;
                                        exit;
                                   end;
                              end;

                              -1 :
                              begin
                                   // Nein, keine Karte gefunden
                                   FQUSBportactive := false;

                                   // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                   if FQUSBStopprocess then
                                   begin
                                        FQUSBStopprocess := false;
                                        FQUSBprocess     := false;
                                        exit;
                                   end;

                                   SetQerrmessage( 1, '' );
                              end;

                              -2 :
                              begin
                                   // Nein, System durcheinander
                                   SetQerrmessage( 11, '' );
                                   FQUSBportactive := false;

                                   // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                   if FQUSBStopprocess then
                                   begin
                                        FQUSBStopprocess := false;
                                        FQUSBprocess     := false;
                                        exit;
                                   end;
                              end;
                         end; // fr case .. of
                    end // fr: if (FQUSBarray[cardaddr].active = false) and (avalue = true) then
                    else
                    begin
                         // Ja, schon offen und soll geschlossen werden
                         if avalue = false then
                         begin
                              // Offen
                              if FQUSBarray[cardaddr].handle <> 0 then
                              begin
                                   // USB-Karte - Schlieen
                                   QAPIExtCloseCard(FQUSBarray[cardaddr].handle);
                                   FQUSBarray[cardaddr].handle := 0;
                              end;

                              FQUSBarray[cardaddr].active := avalue;
                              FQUSBarray[cardaddr].number := 0;
                              FQUSBportactive := avalue;

                              // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                              if FQUSBStopprocess then
                              begin
                                   FQUSBStopprocess := false;
                                   FQUSBprocess     := false;
                                   exit;
                              end;
                         end; // fr: if avalue = false then
                    end; // fr: else
               end // if (CardAddr >= 1) and (CardAddr <= 8) and not (FUSBprocess) and not (FUSBStopProcess) then
               else
               begin
                    //Adresse ist falsch
                    FQUSBportactive := false;

                    // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                    if FQUSBStopprocess then
                    begin
                         FQUSBStopprocess := false;
                         FQUSBprocess     := false;
                         exit;
                    end;

                    SetQerrmessage( 1, '' );
               end;

               FQUSBprocess := false;        // Process ist jetzt abgeschlossen
          end; // fr: user

          // Alles automatisch ausfhren, d.h Karte finden und aktivieren
          auto :
          begin
               // Process nicht aktiviert, dann sind wir jetzt dran !!!!!!
               if not FQUSBprocess then
               begin
                    FQUSBprocess := TRUE;        // Process luft jetzt
                    // Suche QUSB-Karte
                    for CardAddr := 7 downto 0 do
                    begin
                         //Prfen, ob Adresse korrekt angegeben wurde.
                         if ( CardAddr >= 0) and (CardAddr <= 7) and (FQUSBprocess) and not (FQUSBStopProcess) then
                         begin

                              // Gravierende Probleme beim ermitteln der USB-Karte
                              found_usbnr := -2;

                              // Prfen, ob schon offen
                              if (FQUSBarray[cardaddr].active = false) and (avalue = true) then
                              begin
                                   //Nein, USB Karte ffnen
                                   if FQUSBarray[cardaddr].handle = 0 then
                                   begin
                                        FQUSBarray[cardaddr].handle := QAPIExtOpenCard(USBTTL24, cardaddr);
                                        // Prfe, ob Karte geunden wurde!
                                        if FQUSBarray[cardaddr].handle <> 0 then
                                        begin
                                             // Geschaft, USB - Karte da!!
                                             found_usbnr := cardaddr;
                                        end;
                                   end
                                   else
                                   begin
                                        // Pech
                                        found_usbnr := -1;
                                   end;

                                   case found_usbnr of
                                        0..7 :
                                        begin
                                             // Prima Karte gefunden
                                             FQUSBportactive := true;
                                             FQUSBarray[cardaddr].active := FQUSBportactive;
                                             FQUSBarray[cardaddr].number := cardaddr;
                                             FQUSBportaddr := cardaddr +1;  // Fr Anwender 1-8

                                             // Portrichtung festlegen
                                             case USBPortCMD of
                                                  input:
                                                  begin
                                                       FQUSBarray[cardaddr].portcmd := USBPortCMD;
                                                       DDR := DDR AND $F8;
                                                       // set the ddr register ( DDR = data direction register )
                                                       QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                                                  end;
                                                  output:
                                                  begin
                                                       FQUSBarray[cardaddr].portcmd := USBPortCMD;
                                                       // set the ddr register ( DDR = data direction register )
                                                       QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                                                  end;
                                             end;

                                             // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                             if FQUSBStopprocess then
                                             begin
                                                  FQUSBStopprocess := false;
                                                  FQUSBprocess     := false;
                                                  exit;
                                             end;

                                             break;
                                        end;

                                        -1 :
                                        begin
                                             // Pech, keine USB-Karte gefunden
                                             FQUSBportactive := false;

                                             // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                             if FQUSBStopprocess then
                                             begin
                                                  FQUSBStopprocess := false;
                                                  FQUSBprocess     := false;
                                                  exit;
                                             end;
                                        end;

                                        -2 :
                                        begin
                                             // Nein
                                             FQUSBportactive := false;
                                             // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                                             if FQUSBStopprocess then
                                             begin
                                                  FQUSBStopprocess := false;
                                                  FQUSBprocess     := false;
                                                  SetQerrmessage( 11, '' );
                                                  exit;
                                             end;
                                        end;
                                   end; // fr: case found_usbnr of
                              end // fr: if (FUSBarray[cardaddr-1].active = false) and (avalue = true) then
                              else
                              begin
                                   // Ja, schon offen und soll geschlossen werden
                                   if avalue = false then
                                   begin
                                        // Offen
                                        if FQUSBarray[cardaddr].handle <> 0 then
                                        begin
                                             // USB-Karte - Schlieen
                                             QAPIExtCloseCard(FQUSBarray[cardaddr].handle);
                                             FQUSBarray[cardaddr].handle := 0;
                                        end;

                                        FQUSBarray[cardaddr].active := avalue;
                                        FQUSBarray[cardaddr].number := 0;
                                        FQUSBportactive := avalue;
                                   end;
                              end;
                         end // fr: if ( CardAddr >= 1) and (CardAddr <= 8) and (FUSBprocess) and not (FUSBStopProcess) then
                         else
                         begin

                              // Schleifenstruktur unterbrechen, jemand funkt dazwischen
                              if FQUSBStopprocess then
                              begin
                                   FQUSBStopprocess := false;
                                   FQUSBprocess     := false;
                                   exit;
                              end;
                         end;
                    end;  // fr: for CardAddr := 7 downto 0 do

                    FQUSBprocess := false;        // Process ist jetzt abgeschlossen
               end; // if not FUSBprocess then
          end; // fr: auto
     end;
end;

//***************************************************************************
//
// TPort_USB.GetUSBportactive - Status von USB Port
//
// Eingabewerte  :
//
// Rckgabewerte : TRUR = aktive, FALSE = geschlossen
//
//***************************************************************************
function TQPortUSB.GetQUSBportactive : boolean;
var
   CardAddr:longint;
begin
     result := false;
     CardAddr := FQUSBportaddr;

     //Prfen, ob Adresse korrekt angegeben wurde.
     if (CardAddr >= 1 )and (CardAddr <= 8) then
     begin
          dec( CardAddr );
          // Ergebniss zurck
          result := FQUSBarray[cardaddr].active;
     end;
end;



//***************************************************************************
//
// TPort_USB.SetQUSBcommand - USB Port INPUT oder OUTPUT
//
// Eingabewerte  :
//
// Rckgabewerte : INPUT = lesen, OUTPUT = schreiben
//
//***************************************************************************
procedure TQPortUSB.SetQUSBcommand( avalue : TQUSBcommand );
var
   CardAddr, DDR: longint;
begin

     // AUSGABE
     // USB - TTL 24 - OUT (alle Ports Hex $07)
     //
     // DDR := DDR or $01;  // Port 0 - 7
     // DDR := DDR or $02;  // Port 8 - 15
     // DDR := DDR or $04;  // Port 16 - 23
     DDR := 7;

     // Aktive Karte
     CardAddr := USBportaddr -1;

     //Prfen, ob Adresse korrekt angegeben wurde.
     if ( CardAddr >= 0) and (CardAddr <= 7) then
     begin
          // Prfen, ob schon offen
          if FQUSBarray[cardaddr].active then
          begin
               //Ja, USB Karte offnen auch ein Handle vorhanden und ein unterschied besteht
               if (FQUSBarray[cardaddr].handle <> 0) and (avalue <> FQUSBarray[cardaddr].portcmd) then
               begin
                    // Na welche Richtung
                    case avalue of
                         input:
                         begin
                              DDR := DDR AND $F8;
                              FQUSBarray[cardaddr].portcmd := avalue;
                              // set the ddr register ( DDR = data direction register )
                              QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                         end;
                         output:
                         begin
                              FQUSBarray[cardaddr].portcmd := avalue;
                              // set the ddr register ( DDR = data direction register )
                              QAPIExtSpecial(FQUSBarray[cardaddr].handle, JOB_WRITE_DDR, DDR, 0);
                         end;
                    end;
               end;
          end;
     end;
end;


//***************************************************************************
//
// TPort_USB.GetQUSBcommand - USB Port INPUT oder OUTPUT
//
// Eingabewerte  :
//
// Rckgabewerte : INPUT = lesen, OUTPUT = schreiben
//
//***************************************************************************
function TQPortUSB.GetQUSBcommand : TQUSBcommand;
var
   CardAddr: longint;
begin
     result              := INPUT;
     // Aktive Karte
     CardAddr := USBportaddr -1;

     //Prfen, ob Adresse korrekt angegeben wurde.
     if ( CardAddr >= 0) and (CardAddr <= 7) then
     begin
          // Prfen, ob schon offen
          if FQUSBarray[cardaddr].active then
          begin
               //Ja, USB Karte offnen auch ein Handle vorhanden
               if FQUSBarray[cardaddr].handle <> 0 then
               begin
                    // Na welche Richtung
                    result := FQUSBarray[cardaddr].portcmd;
               end;
          end;
     end;
end;



//***************************************************************************
//
// TPort_USB.SetUSBportTest - Test von der USB Karte
//
// Eingabewerte  : True fr die Testaktivierung und nur sollange auf TRUE
//                 bis der Test erledigt ist.
//
// Rckgabewerte : FUSBportTest immer false nach dem Test
//
//***************************************************************************
procedure TQPortUSB.SetQUSBportTest( avalue : boolean );

   // Unterprogramm vom :  SetQUSBportTest
   // Sich eine Pause gnnen und dann dem Windowssytem
   // die Mglichkeit geben, alles andere zu machen.
   procedure Qsleepbetter( avalue : integer );
   var
      count : integer;
   begin
      for count := 0 to avalue do
          begin
             sleep( 1 );
             Application.ProcessMessages;
          end;
   end;

   // Unterprogramm vom :  SetQUSBportTest
   // Multifunktion 0 - 2
   //
   // SetQDigitalupanddown ( cvalue, avalue, tvalue : integer )
   //
   // cvalue =
   //     Schleifendurchlufe
   //
   // avalue =
   // 0 : Digitalkannal einzel setzen
   // 1 : Digitalkannal einzel lschen
   // 2 : Alle Digitalkannle setzen und lschen
   //
   // tvalue =
   //     Pause in Millisekunden setzen
   //
   procedure SetQDigitalupanddown( cvalue, avalue, tvalue : integer );
   var
      count    : integer;
      helplong : longint;
   begin
        helplong := 0;
        count    := 1;
        while ( count < cvalue + 1 ) do
              begin
                   case avalue of
                        // Digitalkannal setzen
                        0 :
                        begin
                        end;
                        // Digitalkannal lschen
                        1 :
                        begin
                        end;
                        // Alle Digitalkannle setzen und lschen
                        2 :
                        begin
                        end;
                   end;
                   // Schlafen
                   Qsleepbetter( tvalue );
                   inc ( count );
              end;
   end;

var
   CardAddr:longint;
begin
     // Prfen , ob nicht schon ein Process luft
     if FQUSBprocess then
     begin
          // Melden das ein Process luft und dann raus
          SetQerrmessage( 9, '' );
          exit;  // Und raus hier.
     end;

     // Prfen, ob der Test noch nicht ausgefhrt wird.
     if avalue <> FQUSBportTest then
     begin
          // Der Test kann jetzt ausgefhrt werden.
          FQUSBportTest := avalue;

          CardAddr :=  FQUSBportaddr;
          //Prfen, ob Adresse korrekt angegeben wurde.
          if (CardAddr >= 1) and (CardAddr <= 8) then
          begin
               // Karten Nummer 0 - 7 und nicht 1 - 8
               dec( cardaddr );

               // Prfen, ob USBport Karte geprft werden soll.
               if (FQUSBarray[cardaddr].active) and (avalue) then
               begin
                    Application.ProcessMessages;

                    // Test beginnt jetzt -->
                    SetQerrmessage( 5, '' );
                    // Digital
                    // Time, Commmand, sleep
                    SetQDigitalupanddown( 8,2,32 );
                    // Digital Test
                    SetQDigitalupanddown( 8,0,32 );
                    // Digital einzel Test
                    SetQDigitalupanddown( 8,1,32 );

                    // <-- Test ist jetzt zu Ende
                    SetQerrmessage( 7, '' );
               end
               else
                   SetQerrmessage( 8, '' );
          end; // fr: if (CardAddr >= 1) and (CardAddr <= 8) then

          // Testende
          FQUSBportTest := false;
     end;
end;



//***************************************************************************
//
// TQPortUSB.SetUSBportAddr - USB Karten - Adresse setzen
//
// Eingabewerte  : avalue : integer    1 - 4

//
// Rckgabewerte :
//
//***************************************************************************
procedure TQPortUSB.SetQUSBportAddr( avalue : integer );
begin
     if not (fQusbprocess) and (avalue <> FQUSBportAddr) then
     begin
          if (avalue >=1) and (avalue <= 8) then
          begin
               FQUSBportAddr := avalue;
          end
          else
          begin
               // Erzwingt eine Adresse
               USBportAddr := 1;
          end;
     end;
end;


//***************************************************************************
//
// TQPortUSB.StopUSBprocess - alle laufendene Processe von USB stoppen
//
// Eingabewerte  :

//
// Rckgabewerte :
//
//***************************************************************************
procedure TQPortUSB.StopQUSBprocess;
begin
     if FQUSBProcess then
     begin
          FQUSBStopProcess := true;
          // Melden das ein Process luft und dann raus
          SetQerrmessage( 9, '' );
     end;
end;



//***************************************************************************
//
// TQPortUSB - Komponente
//
// Routinen fr Port, WPort und DPort.
//
// Port lesen und Port schreiben.

//***************************************************************************

function TQPortUSB.GetQPort :byte;
var
   data : longint;
   datan : Tlongint;
begin
     result := 0;

     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          // Lese Daten von USB-Karte QUSBportAddr
          data := QAPIExtReadDI32(FQUSBarray[USBportAddr-1].handle, 0, 0);
          // Wandle 32 Bit in 8 Bit
          datan := Tlongint(data);
          result := datan.low1;
     end;
end;

function TQPortUSB.GetQWPort :word;
var
   data : longint;
   datan : Twordint;
begin
     result := 0;

     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          // Lese Daten von USB-Karte QUSBportAddr
          data := QAPIExtReadDI32(FQUSBarray[USBportAddr-1].handle, 0, 0);
          // Wandle 32 Bit in 16 Bit
          datan := Twordint(data);
          result := datan.loword;
     end;
end;

function TQPortUSB.GetQDPort :dword;
var
   data : longint;
begin
     result := 0;

     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          // Lese Daten von USB-Karte QUSBportAddr
          data := QAPIExtReadDI32(FQUSBarray[USBportAddr-1].handle, 0, 0);
          result := data;
     end;
end;

//***************************************************************************
//
// Routinen fr Port, WPort und DPort.
//
// Port schreiben Byte.
//
//***************************************************************************
procedure TQPortUSB.SetQPort (Data:byte);
var
   ldata : longint;
begin
     // Cast
     ldata := longint(data);
     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          QAPIExtWriteDO32(FQUSBarray[USBportAddr-1].handle, 0, ldata, 0);
     end;
end;

//***************************************************************************
//
// Routinen fr Port, WPort und DPort.
//
// Port schreiben Word.
//
//***************************************************************************
procedure TQPortUSB.SetQWPort(Data:word);
var
   ldata : longint;
begin
     // Cast
     ldata := longint(data);
     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          QAPIExtWriteDO32(FQUSBarray[USBportAddr-1].handle, 0, ldata, 0);
     end;
end;

//***************************************************************************
//
// Routinen fr Port, WPort und DPort.
//
// Port schreiben Dword.
//
//***************************************************************************
procedure TQPortUSB.SetQDPort(Data:dword);
var
   ldata : longint;
begin
     // Cast
     ldata := longint(data);
     // Prfen, ob USB - Port aktiviert ist
     if QUSBCheckactive and (FQUSBarray[USBportAddr-1].handle <> 0) then
     begin
          QAPIExtWriteDO32(FQUSBarray[USBportAddr-1].handle, 0, ldata, 0);
     end;
end;

//***************************************************************************
//***************************************************************************
//***************************************************************************
//
// Weitere Routinen zur Steuerung vom der USB- Karte.
//
// Port schreiben Dword.
//
//***************************************************************************
//***************************************************************************
//***************************************************************************

function TQPortUSB.QUSBCheckactive : boolean;
begin
     // Prfen, ob USB - Port aktiviert ist und das auch der richitge
     // USB-Port, sonst passiert nichts.
     if (FQUSBportactive) and (FQUSBarray[USBportAddr-1].active) then
        begin
           result := true;
           ErrorNumber := 0;
        end
     else
         begin
            result := false;
            ErrorNumber := 1;
         end;
end;



//***************************************************************************
//***************************************************************************
//***************************************************************************
//
// Fehlerbehandlung fr Komponente.
//
//***************************************************************************
//***************************************************************************
//***************************************************************************


//***************************************************************************
//
// Routinen:  USBCheckerror
//
// Prfen, ob ein Fehler vorhanden ist.
//
//***************************************************************************
function TQPortUSB.QUSBCheckerror    : boolean;
begin
     result := false;
     if FErrNumber > 0 then
        result := true;
end;

//***************************************************************************
//
// Routinen:  USBReaderrnumber
//
// Prfen, welche Fehlernummer vorhanden ist.
//
//***************************************************************************
function TQPortUSB.QUSBReaderrnumber : integer;
begin
     result := 0;
     if QUSBCheckerror then
        result := ErrorNumber;
end;

//***************************************************************************
//
// Routinen:  USBReaderrorstr
//
// Fehler Text zur Verfgung stellen.
//
//***************************************************************************
function TQPortUSB.QUSBReaderrorstr( avalue : integer; svalue : string ): string;
begin

     case ( FQUSBLanguage ) of
          English: begin
                case ( avalue ) of
                    1 : begin
                      result := 'Could not start your USB card. Something was wrong !' + #10#13;
                      result := result + 'Please, check your ' + #10#13;
                      result := result + 'USB wire or QUSB-TLL-24 card.';
                    end;
                    2 : begin
                      result := 'Sorry, these DRIVER are not allowed for' + #10#13;
                      result := result + 'Windows NT 3.51 or NT 4.0.' + #10#13;
                      result := result + 'Check your windows version, please.';
                    end;
                    3 : begin
                      result := 'Could not start your USB card. Something was wrong !' + #10#13;
                      result := result + 'Please, check your ' + #10#13;
                      result := result + 'IOActive variable';
                    end;
                    4 : begin
                      result := 'Sorry, QUSB.DLL are not in your' + #10#13;
                      result := result + 'current path. Check your system, please.' + #10#13;
                    end;
                    5 : begin
                      result := 'Selftest of your USB card: '+ inttostr(USBportAddr) + ' are started' + #10#13;
                      result := result + 'If there an error, please check your card.' + #10#13;
                    end;
                    6 : begin
                      result := 'Attation, these selftest are check your input channel.' + #10#13;
                      result := result + 'Push an Bit' + Svalue + ' to 0 voltage on your USB card, please' + #10#13;
                    end;
                    7 : begin
                      result := 'Self test was closed at these moment.' + #10#13;
                      result := result + 'If there an error, please check your card.';
                    end;
                    8 : begin
                      result := 'Sorry, these USB port are not open.' + #10#13;
                      result := result + 'Check your parameter, please.';
                    end;
                    9 : begin
                      result := 'Wait please, your USB driver init a card these moment.' + #10#13;
                      result := result + 'For deactive message, check internal variable USBProcess' + #10#13;
                      result := result + 'for activate, please.';
                    end;
                    10 : begin
                       result := 'Sorry, none function.';
                    end;
                    11 : begin
                       result := 'Sorry, QPortUSB has not found qlibxdrv.sys.' + #10#13;
                       result := result + 'Please, check your Windows 98, W2K or XP system' + #10#13;
                       result := result + 'of these DLL and executation program.';
                    end;
               end;
          end;
          German: begin
                case ( avalue ) of
                    1 : begin
                      result := 'System konnte die USB - Karte nicht starten.' + #10#13;
                      result := result + 'Bitte berprfen Sie deshalb ihr' + #10#13;
                      result := result + 'USB-Kabel oder die QUSB-TLL-24 Karte.';
                    end;
                    2 : begin
                      result := 'Der Treiber ist nicht erlaubt fr dieses Windows-System:' + #10#13;
                      result := result + 'Windows NT 3.51 or NT 4.0.' + #10#13;
                      result := result + 'Bittte berprfen Sie ihr Winodws-System.';
                    end;
                    3 : begin
                      result := 'System konnte die USB - Karte nicht starten.' + #10#13;
                      result := result + 'Bitte berprfen Sie in der Komponente, ob die' + #10#13;
                      result := result + 'IOActive Variable gesetzt wurde!';
                    end;
                    4 : begin
                      result := 'Leider fehlt die QUSB.DLL Sie befindet sich nicht' + #10#13;
                      result := result + 'im aktuellen System32 - Verzeichnis.' + #10#13;
                      result := result + 'Bitte berprfen Sie ihr System.';
                    end;
                    5 : begin
                      result := 'Selbsttest vo der USB-Kart: '+ inttostr(USBportAddr) + ' wurde gestartet' + #10#13;
                      result := result + 'Wenn hier ein Fehler auftritt, so berprfen Sie bitte die USB-Karte.';
                    end;
                    6 : begin
                      result := 'ACHTUNG:, der Selbsttest prft jetzt die INPUT-Ports.' + #10#13;
                      result := result + 'Legen Sie bitte die Leitung Bit' + Svalue + ' auf 0 Volt, an ihrer USB-Karte';
                    end;
                    7 : begin
                      result := 'Der Selbsttest wird gerade geschlossen, etwas geduldt bitte.' + #10#13;
                      result := result + 'Wenn hier ein Fehler auftritt, so berprfen Sie bitte die USB-Karte.';
                    end;
                    8 : begin
                      result := 'Der USB Port ist leider nicht offen.' + #10#13;
                      result := result + 'Bitte berprfen Sie ihre Parameter.';
                    end;
                    9 : begin
                      result := 'Bitte warten, da gearde der USB-Treiber die Karte initialisiert.' + #10#13;
                      result := result + 'Zum deaktivieren dieser Funktion, siehe Systemvariable USBProcess';
                    end;
                    10 : begin
                       result := 'Keine Function.';
                    end;
                    11 : begin
                       result := 'Die QPortUSB Komponente hat den USB- Treiber oder die USB-' + #10#13;
                       result := result + 'Karte nicht gefunden.  Bittte berprfen Sie ihr Winodws-System.';
                    end;
                end;
          end;
     end;

     result := result + #10#13;

end;



//***************************************************************************
//
// TQPort_USB - Komponente
//
// Ausgabe der Fehlermeldungen
//
//***************************************************************************
procedure TQPortUSB.SetQerrmessage( Value : integer; Svalue : string );
begin

     // Test - Komponente oder Original
     if fcmpname = '' then
        FErrtxt := Name
     else
         ferrtxt := fcmpname;

     ferrtxt := ferrtxt + ' ';         // Leerzeichen

     case ( value ) of
          5..7: ferrtxt := ferrtxt + '- Component test message.';
     else
         ferrtxt := ferrtxt + 'Component - Error';
     end;

     // Aktuellen Fehlertext ermitteln
     fmsgtxt := QUSBReaderrorstr( value, svalue );

     case ( value ) of
          4 : raise EPortUSBComponentExists.Create(fmsgtxt);
     else
         Application.MessageBox( pchar(fmsgtxt), pchar(FErrtxt), MB_OK + MB_ICONERROR);
     end;
end;



end.
