unit QPort_USB_Test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, QPortUSB, HexEdit, NumEdit;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Panel1: TPanel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    HexEdit1: THexEdit;
    RadioGroup3: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
  private
    { Private-Deklarationen }

  public
    { Public-Deklarationen }
    xnum : Tqportusb;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     xnum := TQPortUSB.create(self);
     xnum.USBportconnect := user;
     xnum.USBLanguage := German;



end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     if xnum.USBprocess then
        begin
             Action := caNone;
             xnum.StopQUSBprocess;
        end
           else
               xnum.free;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
      xnum.USBportactive := true;
      if xnum.USBportactive then
      begin
           Panel1.Color := clgreen;
           panel1.Caption := 'Karte offen';
           RadioGroup1.ItemIndex := xnum.USBportAddr -1;
      end;
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
     xnum.USBportactive := false;
     Panel1.Color := clred;
     panel1.Caption := 'Karte geschlossen';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   xnum.USBportTest := true;

   while xnum.USBportTest do
      ShowMessage('Test luft noch !!!!.')
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
     hexedit1.NumRETURN := true;
     xnum.DPort := hexedit1.Hexvalue;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
     xnum.USBportAddr := RadioGroup1.ItemIndex + 1;
     if xnum.USBportactive then
        begin
             Panel1.Color := clgreen;
             panel1.Caption := 'Karte offen';
        end
     else
        begin
             Panel1.Color := clred;
             panel1.Caption := 'Karte geschlossen';
        end;
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
     case RadioGroup2.ItemIndex of
          0 : xnum.USBportconnect := user;
          1 : xnum.USBportconnect := auto;
          end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    hexedit1.text := inttohex( xnum.DPort, 6 );
end;



procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
     if RadioGroup3.ItemIndex = 0 then
        xnum.USBPortCMD := input;

     if RadioGroup3.ItemIndex = 1 then
        xnum.USBPortCMD := OUTPUT;

end;

end.
