unit QPortUSBAbout;

{
Beispielaufruf :

var
  Form1: TForm1;
  xAbout : TAboutInfo;

implementation

$R *.DFM

procedure TForm1.Button1Click(Sender: TObject);
begin
     xabout := taboutinfo.create;
     xabout.compiler := 'Delphi 2.0';
     xabout.title := 'Component TAnalyser';
     xabout.firststring := 'TAnalyser Component';
     xabout.version := '1.00';
     xabout.laststring := '(c) 1999';

     xabout.free;
end;


procedure Register;
begin
  RegisterComponents('Drivers', [TAnalyser]);
  RegisterPropertyEditor(TypeInfo(TAboutInfo), TAnalyser, 'ABOUT', TAboutInfo);
 end;                                              .
                                                   .
                                                Neue Komponente

 Legende
  11.01.2000  V1.00  Aufbau von einer AboutInfo-Klasse wurde festgelegt.
                     Ist fr Komponenten gedacht, damit allgemeine Daten in
                     der Komponente angezeigt werden knnen.

  13.01.2000  V1.01  Fehler beseitigt in der Edit-Routine.
                     Jetzt mte die Messagebox richtig kommen.

  16.01.2000         procedure SetValue(const Value: string); override;
                     Wird vom Objektinspektor dannbenutzt, wenn eine sichbare
                     Eigenschaft verndert wird und diese ist als ein
                     String-Value abgelegt. Dann wird SetValue aufgerufen.
                     Nicht aber bei public gemachten Eigenschaften die
                     bleiben unsichtbar und werden in der Edit-Routine auch
                     nicht gesehen.

}



interface

uses DsgnIntf, Forms, Winprocs, SysUtils, Classes;

type
{ ---------------------------------------------------------------------
  Versionsangabe fr Komponenten
  --------------------------------------------------------------------- }
TQPortUSBAbout = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

implementation

uses QPortUSB;

{ ****************************************************************************
  ****************************************************************************
  INTERNE-Routinen fr  : PropertyEditor
  ****************************************************************************
  **************************************************************************** }

{ *************************************************
  INTERN
  PropertyEditor
  Die Methode Edit ruft eine Messagebox auf.
  Hier wird die Versions-Nr. ausgegeben.

  ************************************************* }
procedure TQPortUSBAbout.Edit;
begin
  Application.MessageBox('TQPortUSB Component ' + #10 + #13 +
                         'Version ' + FVersion + ' for Delphi 2.0-5.0.' + #10#13 +
                         'DLL-Driver of www.quantum.com and converted' + #10#13 +
                         'by (c) 2007 Herbert Mak.',
                         'About TQPortUSB Component', MB_OK + MB_ICONINFORMATION);
end;
{ *************************************************
  INTERN
  PropertyEditor
  Die Methode GetAttributes legt die Attribute fest.
  Hier MultSelect, Dialog und nur lesen.

  ************************************************* }
function TQPortUSBAbout.GetAttributes: TPropertyAttributes;
begin
  Result:= [paDialog];
end;
{ *************************************************
  INTERN
  PropertyEditor
  Die Methode GetValue gibt einen String aus '(About)'.
  Es steht nichts weiter in dieser Variablen aber, wenn man drei Punkte sieht,
  so ist der PropertyEditor eingestellt fr diese Variable.

  ************************************************* }
function TQPortUSBAbout.GetValue: string;
begin
  Result:= '(About)';
end;


end.

