unit Kompo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Hexgrid, ExtCtrls, Grids;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    FontDialog1: TFontDialog;
    Button3: TButton;
    Button2: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);

  private
    { Private-Deklarationen }
    mem : Tmemorystream;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  TK: THexgrid;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);

begin
     mem := tmemorystream.create;
     mem.size := $8000;

     tk := Thexgrid.create(self);
     tk.parent := self;
     tk.height := 400;
     tk.width := 610;
     tk.Visible := true;
     tk.font.name := 'Courier New';
     tk.font.Size := 10;
     tk.hint := 'Test';
     tk.hexhint := 'Hexzeile';
     tk.showhexhint := true;
     tk.showhint := false;
     tk.options := [goFixedVertLine,goRowMoving,goColMoving,goRangeSelect,goEditing];
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin

     tk.free;
     mem.free;

end;

procedure TForm1.Button1Click(Sender: TObject);
var
  F: Textfile;
begin
  OpenDialog1.Title := 'Datei - STREAM laden';
  if OpenDialog1.Execute then begin
    AssignFile(F, OpenDialog1.FileName);
    try
      Reset(F);
      mem.size := FileSize(f);
       CloseFile(F);
      mem.loadfromfile(OpenDialog1.FileName);
      tk.Stream := mem;
    except
      on EInOutError do

        MessageDlg('Datei-E/A-Fehler', mtError, [mbOk], 0);
    end;
  end;

end;


procedure TForm1.Button2Click(Sender: TObject);
begin
          tk.ClearStream;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
   x : integer;
begin

for x:= 0 to 255 do
    tk.streambyte[longint(x)] := x;
    tk.repaint;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
          tk.MoveStream( 0, $1f, $50 );
          tk.repaint;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
     tk.copystream( 0, $1f, $d0 );

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
     if (FontDialog1.execute) then begin
        tk.font := FontDialog1.font;
        repaint;
        end;
end;





procedure TForm1.Button7Click(Sender: TObject);
begin
     tk.Soffset := $100;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
     tk.Soffset := $0;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
    tk.SetGotostream( $0 );
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
     tk.SetGotostream( $FF0 );
end;

end.
